﻿using com.caen.RFIDLibrary;

// The CAEN RFID callback for EventInventoryTag method: it will be call
// on each tag found.

/**
* NOTE: in windows all reader can be connected ONLY with these 
* communication channels using Connect method.
* 
* - Via Network               ->   CAENRFID_TCP
* - Via Bluetooth Classic/USB/RS232   ->   CAENRFID_RS232 
* 
* 
* This Console application show a very basic usage of CAENRFID API.
* 1) Connect the reader
* 2) Set power to conducted 50 mW 
* 3) register CAENRFID Event callback for EventInventoryTag method.
* 4) prepare and launch continuous inventory with EventInventoryTag method.
* 5) Waits for 10 seconds, and in the meanwhile, any identidfied tag will raise 
*    the callback.
* 6) Stop the continuous reading.
* 7) Unregister callback
* 8) Disconnect the reader.
*/
void Reader_CAENRFIDEvent(object Sender, CAENRFIDEventArgs Event)
{
    CAENRFIDNotify tag = Event.Data[0]; // It's always one tag at time.
    Console.WriteLine("Tag with id: " + BitConverter.ToString(tag.TagID).Replace("-", ""));
}

try
{
    CAENRFIDReader reader = new CAENRFIDReader();
    // RS232 is also for BLUETOOTH CLASSIC (no BLE) and USB connection
    // The COM PORT will be mounted on BLUETOOTH BINDING or USB Attachment.
    // See COM Port in Windows Device Management, or reader User/Tech manual.
    reader.Connect(CAENRFIDPort.CAENRFID_RS232, "/dev/cu.usbserial-1140");
    //In the address parameter developer can specify different baud rate
    //like the following example:
    //reader.Connect(CAENRFIDPort.CAENRFID_RS232, "/dev/tty.usbserial-1140:921600:8:N:1");
    //reader.Connect(CAENRFIDPort.CAENRFID_RS232, "COM5");
    CAENRFIDReaderInfo info = reader.GetReaderInfo();
    Console.WriteLine("Reader infos: " + info.GetModel() + " and " + info.GetSerialNumber());
    reader.SetPower(50);
    short flag = (short)(CAENRFIDLogicalSource.InventoryFlag.CONTINUOS | CAENRFIDLogicalSource.InventoryFlag.FRAMED);
    reader.CAENRFIDEvent += Reader_CAENRFIDEvent;
    reader.GetSource("Source_0").SetReadCycle(0);
    reader.GetSource("Source_0").EventInventoryTag(new byte[] { }, 0, 0, flag);
    Thread.Sleep(5000);
    reader.InventoryAbort();
    reader.Disconnect();
    reader.CAENRFIDEvent -= Reader_CAENRFIDEvent;
}
catch (CAENRFIDException crex)
{
    Console.WriteLine("Error details: " + crex.getError());
}



